﻿//=============================================================================
// MoveCommand.js
//=============================================================================

var Imported = Imported || {};
Imported.MoveCommand = true;

/*:
 * @plugindesc 移動コマンド ウィンドウを表示するスクリプト
 */

(function ()
{
    //-----------------------------------------------------------------------------
    // Scene_MoveCommand
    //
    function Scene_MoveCommand()
    {
        this.initialize.apply(this, arguments);
    }

    Scene_MoveCommand.prototype = Object.create(Scene_MenuBase.prototype);
    Scene_MoveCommand.prototype.constructor = Scene_MoveCommand;

    // 作成
    Scene_MoveCommand.prototype.create = function ()
    {
        Scene_MenuBase.prototype.create.call(this);
        this.createMoveCommandWindow();
    };

    // 移動コマンド ウィンドウの作成
    Scene_MoveCommand.prototype.createMoveCommandWindow = function ()
    {
        this._interpreter = new Game_Interpreter();

        this._moveCommandWindow = new Window_Message();
        this.addWindow(this._moveCommandWindow);
        this._moveCommandWindow.subWindows().forEach(function (window)
        {
            this.addWindow(window);
        }, this);

        $gameMessage.add("어디로 이동 하시겠습니까?");

        // ダンジョン内かつダンジョン初挑戦済み
        if (!$gameSwitches.value(4) && $gameSwitches.value(64))
        {
            this.setupChoices([["공방", "던전", "술집", "여관", "상점"], 6, 0, 2, 0], false);
        }
        else
        {
            this.setupChoices([["공방", "술집", "여관", "상점"], 6, 0, 2, 0], true);
        }
    };

    // Game_Interpreter をそのまま持ってきた
    Scene_MoveCommand.prototype.setupChoices = function (params, shouldAdd)
    {
        var choices = params[0].clone();
        var cancelType = params[1];
        var defaultType = params.length > 2 ? params[2] : 0;
        var positionType = params.length > 3 ? params[3] : 2;
        var background = params.length > 4 ? params[4] : 0;
        if (cancelType >= choices.length)
        {
            cancelType = -2;
        }
        $gameMessage.setChoices(choices, defaultType, cancelType);
        $gameMessage.setChoiceBackground(background);
        $gameMessage.setChoicePositionType(positionType);
        $gameMessage.setChoiceCallback(function (n)
        {
            this._branch[this._indent] = n;

            if (shouldAdd && n != 0)
            {
                n += 1;
            }
            $gameVariables.setValue(2, n);

            if (n >= 0)
            {
                // 移動コマンド
                $gameSwitches.setValue(3, true);

                while (SceneManager._stack.length > 0)
                {
                    SceneManager.pop();
                }
            }
            else
            {
                // 移動コマンド
                $gameSwitches.setValue(3, false);

                SceneManager.pop();
            }
        }.bind(this._interpreter));
    };

    // YEP_MainMenuManager へ渡す関数
    Scene_Menu.prototype.commandMove = function ()
    {
        SceneManager.push(Scene_MoveCommand);
    };
})();
